<?php
include 'includes/db_connect.php';
include 'includes/functions.php';
include 'includes/secure_headers.php';

// Check if user is logged in and is admin
if (!isLoggedIn() || !isAdmin()) {
    redirect('login.php');
}

$user_id = $_SESSION['user_id'];

// Get system statistics
$stats_stmt = $pdo->prepare("
    SELECT 
        (SELECT COUNT(*) FROM users WHERE role = 'Company') as total_companies,
        (SELECT COUNT(*) FROM users WHERE role = 'Provision Store') as total_stores,
        (SELECT COUNT(*) FROM products) as total_products,
        (SELECT COUNT(*) FROM orders) as total_orders,
        (SELECT SUM(total_price) FROM orders WHERE payment_status = 'Paid') as total_revenue,
        (SELECT COUNT(*) FROM orders WHERE status = 'Pending') as pending_orders,
        (SELECT COUNT(*) FROM messages WHERE DATE(created_at) = CURDATE()) as today_messages
");
$stats_stmt->execute();
$stats = $stats_stmt->fetch(PDO::FETCH_ASSOC);

// Get recent activities
$activities_stmt = $pdo->prepare("
    (SELECT 'order' as type, id, CONCAT('New order #', id) as description, created_at FROM orders ORDER BY created_at DESC LIMIT 5)
    UNION ALL
    (SELECT 'user' as type, id, CONCAT('New ', role, ' registration: ', first_name, ' ', last_name) as description, created_at FROM users ORDER BY created_at DESC LIMIT 5)
    UNION ALL
    (SELECT 'message' as type, id, 'New support message' as description, created_at FROM messages ORDER BY created_at DESC LIMIT 5)
    ORDER BY created_at DESC LIMIT 10
");
$activities_stmt->execute();
$recent_activities = $activities_stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard - MultiVendor System</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        .sidebar {
            background: linear-gradient(135deg, #dc3545 0%, #c82333 100%);
            color: white;
            min-height: 100vh;
            position: fixed;
            width: 250px;
        }
        .sidebar .nav-link {
            color: white;
            padding: 15px 20px;
            border-bottom: 1px solid rgba(255,255,255,0.1);
        }
        .sidebar .nav-link:hover, .sidebar .nav-link.active {
            background: rgba(255,255,255,0.1);
        }
        .main-content {
            margin-left: 250px;
            padding: 20px;
        }
        .stat-card {
            border: none;
            border-radius: 15px;
            transition: transform 0.3s;
        }
        .stat-card:hover {
            transform: translateY(-5px);
        }
        .bg-admin { background: linear-gradient(135deg, #dc3545, #c82333); }
    </style>
</head>
<body>
    <!-- Sidebar -->
    <div class="sidebar">
        <div class="sidebar-header text-center py-4">
            <h4><i class="fas fa-crown me-2"></i>Admin Panel</h4>
            <p class="mb-0 text-light">System Administrator</p>
        </div>
        <nav class="nav flex-column">
            <a class="nav-link active" href="admin_dashboard.php">
                <i class="fas fa-tachometer-alt"></i>Dashboard
            </a>
            <a class="nav-link" href="admin_users.php">
                <i class="fas fa-users"></i>Manage Users
            </a>
            <a class="nav-link" href="admin_products.php">
                <i class="fas fa-boxes"></i>Manage Products
            </a>
            <a class="nav-link" href="admin_orders.php">
                <i class="fas fa-shopping-cart"></i>Manage Orders
            </a>
            <a class="nav-link" href="admin_transactions.php">
                <i class="fas fa-money-bill-wave"></i>Transactions
            </a>
            <a class="nav-link" href="admin_messages.php">
                <i class="fas fa-comments"></i>System Messages
            </a>
            <a class="nav-link" href="admin_settings.php">
                <i class="fas fa-cog"></i>System Settings
            </a>
            <a class="nav-link" href="logout.php">
                <i class="fas fa-sign-out-alt"></i>Logout
            </a>
        </nav>
    </div>

    <!-- Main Content -->
    <div class="main-content">
        <!-- Top Navbar -->
        <nav class="navbar navbar-expand-lg navbar-light bg-white shadow-sm mb-4">
            <div class="container-fluid">
                <span class="navbar-brand mb-0 h1">Admin Dashboard</span>
                <div class="navbar-nav ms-auto">
                    <span class="navbar-text">
                        <i class="fas fa-user-shield me-1"></i>
                        <?php echo $_SESSION['first_name'] . ' ' . $_SESSION['last_name']; ?>
                    </span>
                </div>
            </div>
        </nav>

        <!-- Statistics Cards -->
        <div class="row">
            <div class="col-xl-2 col-md-4 col-6 mb-4">
                <div class="card text-white bg-admin stat-card">
                    <div class="card-body text-center">
                        <h2 class="mb-0"><?php echo $stats['total_companies']; ?></h2>
                        <p class="mb-0">Companies</p>
                    </div>
                </div>
            </div>
            <div class="col-xl-2 col-md-4 col-6 mb-4">
                <div class="card text-white bg-success stat-card">
                    <div class="card-body text-center">
                        <h2 class="mb-0"><?php echo $stats['total_stores']; ?></h2>
                        <p class="mb-0">Stores</p>
                    </div>
                </div>
            </div>
            <div class="col-xl-2 col-md-4 col-6 mb-4">
                <div class="card text-white bg-primary stat-card">
                    <div class="card-body text-center">
                        <h2 class="mb-0"><?php echo $stats['total_products']; ?></h2>
                        <p class="mb-0">Products</p>
                    </div>
                </div>
            </div>
            <div class="col-xl-2 col-md-4 col-6 mb-4">
                <div class="card text-white bg-info stat-card">
                    <div class="card-body text-center">
                        <h2 class="mb-0"><?php echo $stats['total_orders']; ?></h2>
                        <p class="mb-0">Orders</p>
                    </div>
                </div>
            </div>
            <div class="col-xl-2 col-md-4 col-6 mb-4">
                <div class="card text-white bg-warning stat-card">
                    <div class="card-body text-center">
                        <h2 class="mb-0">₦<?php echo number_format($stats['total_revenue'], 0); ?></h2>
                        <p class="mb-0">Revenue</p>
                    </div>
                </div>
            </div>
            <div class="col-xl-2 col-md-4 col-6 mb-4">
                <div class="card text-white bg-danger stat-card">
                    <div class="card-body text-center">
                        <h2 class="mb-0"><?php echo $stats['pending_orders']; ?></h2>
                        <p class="mb-0">Pending</p>
                    </div>
                </div>
            </div>
        </div>

        <div class="row mt-4">
            <!-- Recent Activities -->
            <div class="col-lg-8">
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title mb-0">
                            <i class="fas fa-history me-2"></i>Recent Activities
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="list-group list-group-flush">
                            <?php foreach ($recent_activities as $activity): ?>
                                <div class="list-group-item d-flex justify-content-between align-items-center">
                                    <div>
                                        <span class="badge 
                                            <?php 
                                            switch($activity['type']) {
                                                case 'order': echo 'bg-primary'; break;
                                                case 'user': echo 'bg-success'; break;
                                                case 'message': echo 'bg-info'; break;
                                                default: echo 'bg-secondary';
                                            }
                                            ?> me-2">
                                            <?php echo ucfirst($activity['type']); ?>
                                        </span>
                                        <?php echo $activity['description']; ?>
                                    </div>
                                    <small class="text-muted">
                                        <?php echo date('M j, g:i A', strtotime($activity['created_at'])); ?>
                                    </small>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Quick Actions -->
            <div class="col-lg-4">
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title mb-0">
                            <i class="fas fa-bolt me-2"></i>Quick Actions
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="d-grid gap-2">
                            <a href="admin_users.php" class="btn btn-outline-primary">
                                <i class="fas fa-user-plus me-2"></i>Add New User
                            </a>
                            <a href="admin_products.php" class="btn btn-outline-success">
                                <i class="fas fa-box me-2"></i>View All Products
                            </a>
                            <a href="admin_orders.php" class="btn btn-outline-info">
                                <i class="fas fa-shopping-cart me-2"></i>Manage Orders
                            </a>
                            <a href="admin_settings.php" class="btn btn-outline-warning">
                                <i class="fas fa-cog me-2"></i>System Settings
                            </a>
                        </div>
                    </div>
                </div>

                <!-- System Status -->
                <div class="card mt-4">
                    <div class="card-header">
                        <h5 class="card-title mb-0">
                            <i class="fas fa-server me-2"></i>System Status
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-2">
                            <small class="text-muted">Messages Today:</small>
                            <strong class="float-end"><?php echo $stats['today_messages']; ?></strong>
                        </div>
                        <div class="mb-2">
                            <small class="text-muted">System Uptime:</small>
                            <strong class="float-end">100%</strong>
                        </div>
                        <div class="mb-2">
                            <small class="text-muted">Last Backup:</small>
                            <strong class="float-end"><?php echo date('M j, Y'); ?></strong>
                        </div>
                        <div class="mb-0">
                            <small class="text-muted">PHP Version:</small>
                            <strong class="float-end"><?php echo phpversion(); ?></strong>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>