<?php
include 'includes/db_connect.php';

echo "<h3>Database Check</h3>";

// Check if messages table exists
$tables = ['users', 'products', 'orders', 'transactions', 'messages', 'notifications'];

foreach ($tables as $table) {
    try {
        $result = $pdo->query("SELECT 1 FROM $table LIMIT 1");
        echo "<p style='color: green;'>✓ Table '$table' exists</p>";
    } catch (PDOException $e) {
        echo "<p style='color: red;'>✗ Table '$table' is missing: " . $e->getMessage() . "</p>";
    }
}

// Check sample data in messages table
try {
    $stmt = $pdo->query("SELECT COUNT(*) as count FROM messages");
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    echo "<p>Messages in database: " . $result['count'] . "</p>";
} catch (PDOException $e) {
    echo "<p style='color: red;'>Error checking messages: " . $e->getMessage() . "</p>";
}

// Check users with different roles
try {
    $stmt = $pdo->query("SELECT role, COUNT(*) as count FROM users GROUP BY role");
    $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "<h4>User Count by Role:</h4>";
    foreach ($results as $row) {
        echo "<p>{$row['role']}: {$row['count']} users</p>";
    }
} catch (PDOException $e) {
    echo "<p style='color: red;'>Error checking users: " . $e->getMessage() . "</p>";
}
?>