<?php
// Store Sidebar Component
?>
<!-- Sidebar -->
<div class="sidebar" id="sidebar" style="background: linear-gradient(135deg, #42b883 0%, #47b8a4 100%); color: white; min-height: 100vh; position: fixed; width: 250px; transition: all 0.3s;">
    <div class="sidebar-header text-center py-4">
        <h4><i class="fas fa-store me-2"></i>Store Panel</h4>
        <p class="mb-0 text-light"><?php echo $_SESSION['first_name'] . ' ' . $_SESSION['last_name']; ?></p>
        <small class="text-light"><?php echo $_SESSION['state'] . ', ' . $_SESSION['lga']; ?></small>
    </div>
    <nav class="nav flex-column">
        <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'store_dashboard.php' ? 'active' : ''; ?>" href="store_dashboard.php" style="color: white; padding: 15px 20px; border-bottom: 1px solid rgba(255,255,255,0.1); transition: all 0.3s;">
            <i class="fas fa-tachometer-alt"></i>Dashboard
        </a>
        <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'store_orders.php' ? 'active' : ''; ?>" href="store_orders.php" style="color: white; padding: 15px 20px; border-bottom: 1px solid rgba(255,255,255,0.1); transition: all 0.3s;">
            <i class="fas fa-shopping-cart"></i>Make Order
        </a>
        <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'store_order_history.php' ? 'active' : ''; ?>" href="store_order_history.php" style="color: white; padding: 15px 20px; border-bottom: 1px solid rgba(255,255,255,0.1); transition: all 0.3s;">
            <i class="fas fa-history"></i>Order History
        </a>
        <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'store_transactions.php' ? 'active' : ''; ?>" href="store_transactions.php" style="color: white; padding: 15px 20px; border-bottom: 1px solid rgba(255,255,255,0.1); transition: all 0.3s;">
            <i class="fas fa-money-bill-wave"></i>Transactions
        </a>
        <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'store_messages.php' ? 'active' : ''; ?>" href="store_messages.php" style="color: white; padding: 15px 20px; border-bottom: 1px solid rgba(255,255,255,0.1); transition: all 0.3s;">
            <i class="fas fa-comments"></i>Support
        </a>
        <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'store_profile.php' ? 'active' : ''; ?>" href="store_profile.php" style="color: white; padding: 15px 20px; border-bottom: 1px solid rgba(255,255,255,0.1); transition: all 0.3s;">
            <i class="fas fa-user-cog"></i>Profile
        </a>
        <a class="nav-link" href="logout.php" style="color: white; padding: 15px 20px; border-bottom: 1px solid rgba(255,255,255,0.1); transition: all 0.3s;">
            <i class="fas fa-sign-out-alt"></i>Logout
        </a>
    </nav>
</div>

<!-- Mobile Toggle Button (hidden by default) -->
<button class="btn btn-outline-success me-3 d-md-none" id="sidebarToggle" style="display: none;">
    <i class="fas fa-bars"></i>
</button>

<script>
    // Sidebar toggle for mobile
    document.addEventListener('DOMContentLoaded', function() {
        const sidebarToggle = document.getElementById('sidebarToggle');
        const sidebar = document.getElementById('sidebar');
        
        if (sidebarToggle && sidebar) {
            sidebarToggle.addEventListener('click', function() {
                sidebar.style.marginLeft = sidebar.style.marginLeft === '0px' ? '-250px' : '0px';
            });
        }
        
        // Auto-hide sidebar on mobile when clicking outside
        document.addEventListener('click', function(event) {
            if (window.innerWidth <= 768 && 
                !sidebar.contains(event.target) && 
                !sidebarToggle.contains(event.target) &&
                sidebar.style.marginLeft === '0px') {
                sidebar.style.marginLeft = '-250px';
            }
        });
        
        // Handle window resize
        window.addEventListener('resize', function() {
            if (window.innerWidth > 768) {
                sidebar.style.marginLeft = '0px';
                sidebarToggle.style.display = 'none';
            } else {
                sidebarToggle.style.display = 'block';
            }
        });
        
        // Initial check
        if (window.innerWidth <= 768) {
            sidebarToggle.style.display = 'block';
            sidebar.style.marginLeft = '-250px';
        }
    });
</script>