<?php
include 'includes/db_connect.php';
include 'includes/functions.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Multi-Vendor Ordering System - Home</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        .hero-section {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 100px 0;
            text-align: center;
        }
        .feature-card {
            transition: transform 0.3s, box-shadow 0.3s;
            border: none;
            border-radius: 15px;
            margin-bottom: 20px;
        }
        .feature-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 10px 25px rgba(0,0,0,0.1);
        }
        .feature-icon {
            font-size: 3rem;
            margin-bottom: 20px;
            color: #667eea;
        }
        .btn-custom {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            padding: 12px 30px;
            border-radius: 25px;
            font-weight: 600;
            transition: all 0.3s;
        }
        .btn-custom:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0,0,0,0.2);
            color: white;
        }
        .app-badges img {
            height: 50px;
            margin: 10px;
            transition: transform 0.3s;
        }
        .app-badges img:hover {
            transform: scale(1.1);
        }
        .stats-section {
            background: #f8f9fa;
            padding: 80px 0;
        }
        .stat-number {
            font-size: 3rem;
            font-weight: bold;
            color: #667eea;
        }
        .navbar-brand {
            font-weight: bold;
            font-size: 1.5rem;
        }
    </style>
</head>
<body>
    <!-- Navigation -->
    <nav class="navbar navbar-expand-lg navbar-light bg-white shadow-sm">
        <div class="container">
            <a class="navbar-brand" href="index.php">
                <i class="fas fa-store me-2"></i>MultiVendor
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item">
                        <a class="nav-link active" href="index.php">Home</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#features">Features</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#about">About</a>
                    </li>
                    <?php if (isLoggedIn()): ?>
                        <?php if (isCompany()): ?>
                            <li class="nav-item">
                                <a class="nav-link" href="company_dashboard.php">Dashboard</a>
                            </li>
                        <?php elseif (isStore()): ?>
                            <li class="nav-item">
                                <a class="nav-link" href="store_dashboard.php">Dashboard</a>
                            </li>
                        <?php endif; ?>
                        <li class="nav-item">
                            <a class="nav-link" href="logout.php">Logout</a>
                        </li>
                    <?php else: ?>
                        <li class="nav-item">
                            <a class="nav-link" href="login.php">Login</a>
                        </li>
                        <li class="nav-item">
                            <a class="btn btn-custom ms-2" href="signup.php">Get Started</a>
                        </li>
                    <?php endif; ?>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Hero Section -->
    <section class="hero-section">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6">
                    <h1 class="display-4 fw-bold mb-4">Streamline Your Business Operations</h1>
                    <p class="lead mb-4">Connect companies with provision stores seamlessly. Manage orders, track inventory, and grow your business with our comprehensive multi-vendor platform.</p>
                    <div class="d-flex flex-wrap gap-3">
                        <?php if (!isLoggedIn()): ?>
                            <a href="signup.php" class="btn btn-light btn-lg px-4 py-2">
                                <i class="fas fa-user-plus me-2"></i>Register Now
                            </a>
                        <?php endif; ?>
                        <a href="login.php" class="btn btn-outline-light btn-lg px-4 py-2">
                            <i class="fas fa-sign-in-alt me-2"></i>Login
                        </a>
                        <a href="signup.php" class="btn btn-outline-light btn-lg px-4 py-2">
                            <i class="fas fa-mobile-alt me-2"></i>Register Now
                        </a>
                    </div>
                </div>
                <div class="col-lg-6 text-center">
                    <img src="assets/images/logo.jpeg" 
                         alt="Business Collaboration" 
                         class="img-fluid rounded-3 shadow-lg"
                         style="max-height: 400px;">
                </div>
            </div>
        </div>
    </section>

    <!-- Features Section -->
    <section id="features" class="py-5">
        <div class="container">
            <div class="text-center mb-5">
                <h2 class="display-5 fw-bold">Powerful Features</h2>
                <p class="lead text-muted">Everything you need to manage your business efficiently</p>
            </div>
            <div class="row g-4">
                <div class="col-md-4">
                    <div class="card feature-card h-100 shadow">
                        <div class="card-body text-center p-4">
                            <div class="feature-icon">
                                <i class="fas fa-boxes"></i>
                            </div>
                            <h4 class="card-title">Inventory Management</h4>
                            <p class="card-text">Track your products, manage stock levels, and get low-stock alerts in real-time.</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card feature-card h-100 shadow">
                        <div class="card-body text-center p-4">
                            <div class="feature-icon">
                                <i class="fas fa-shopping-cart"></i>
                            </div>
                            <h4 class="card-title">Order Processing</h4>
                            <p class="card-text">Streamlined order management from placement to delivery with real-time tracking.</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card feature-card h-100 shadow">
                        <div class="card-body text-center p-4">
                            <div class="feature-icon">
                                <i class="fas fa-chart-line"></i>
                            </div>
                            <h4 class="card-title">Sales Analytics</h4>
                            <p class="card-text">Comprehensive reports and insights to help you make data-driven business decisions.</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card feature-card h-100 shadow">
                        <div class="card-body text-center p-4">
                            <div class="feature-icon">
                                <i class="fas fa-comments"></i>
                            </div>
                            <h4 class="card-title">Direct Messaging</h4>
                            <p class="card-text">Communicate directly with your business partners through our integrated chat system.</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card feature-card h-100 shadow">
                        <div class="card-body text-center p-4">
                            <div class="feature-icon">
                                <i class="fas fa-money-bill-wave"></i>
                            </div>
                            <h4 class="card-title">Secure Payments</h4>
                            <p class="card-text">Multiple payment options including Aspay and Flutterwave with secure transaction processing.</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card feature-card h-100 shadow">
                        <div class="card-body text-center p-4">
                            <div class="feature-icon">
                                <i class="fas fa-mobile-alt"></i>
                            </div>
                            <h4 class="card-title">Mobile Responsive</h4>
                            <p class="card-text">Access your dashboard and manage your business from any device, anywhere.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Stats Section -->
    <section class="stats-section">
        <div class="container">
            <div class="row text-center">
                <div class="col-md-3 col-6 mb-4">
                    <div class="stat-number">500+</div>
                    <p class="text-muted">Businesses Registered</p>
                </div>
                <div class="col-md-3 col-6 mb-4">
                    <div class="stat-number">10K+</div>
                    <p class="text-muted">Orders Processed</p>
                </div>
                <div class="col-md-3 col-6 mb-4">
                    <div class="stat-number">200+</div>
                    <p class="text-muted">Cities Covered</p>
                </div>
                <div class="col-md-3 col-6 mb-4">
                    <div class="stat-number">99%</div>
                    <p class="text-muted">Satisfaction Rate</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Download App Section -->
    <section id="download" class="py-5 bg-light">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6">
                    <h2 class="display-6 fw-bold mb-4">Download Our Mobile App</h2>
                    <p class="lead mb-4">Manage your business on the go with our feature-packed mobile application. Available on both iOS and Android platforms.</p>
                    <div class="app-badges">
                        <a href="#" class="d-inline-block me-3">
                            <img src="https://developer.apple.com/app-store/marketing/guidelines/images/badge-download-on-the-app-store.svg" alt="Download on App Store">
                        </a>
                        <a href="#" class="d-inline-block">
                            <img src="https://play.google.com/intl/en_us/badges/static/images/badges/en_badge_web_generic.png" alt="Get it on Google Play" style="height: 60px;">
                        </a>
                    </div>
                </div>
                <div class="col-lg-6 text-center">
                    <img src="https://cdn.pixabay.com/photo/2015/02/02/11/09/office-620822_1280.jpg" 
                         alt="Mobile App" 
                         class="img-fluid rounded-3 shadow"
                         style="max-height: 300px;">
                </div>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="bg-dark text-white py-4">
        <div class="container">
            <div class="row">
                <div class="col-md-6">
                    <h5><i class="fas fa-store me-2"></i>MultiVendor System</h5>
                    <p class="mb-0">Connecting companies and provision stores for seamless business operations.</p>
                </div>
                <div class="col-md-6 text-md-end">
                    <p class="mb-0">&copy; <?php echo date('Y'); ?> MultiVendor System. All rights reserved.</p>
                    <div class="mt-2">
                        <a href="#" class="text-white me-3"><i class="fab fa-facebook-f"></i></a>
                        <a href="#" class="text-white me-3"><i class="fab fa-twitter"></i></a>
                        <a href="#" class="text-white me-3"><i class="fab fa-linkedin-in"></i></a>
                        <a href="#" class="text-white"><i class="fab fa-instagram"></i></a>
                    </div>
                </div>
            </div>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Smooth scrolling for anchor links
        document.querySelectorAll('a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function (e) {
                e.preventDefault();
                const target = document.querySelector(this.getAttribute('href'));
                if (target) {
                    target.scrollIntoView({
                        behavior: 'smooth',
                        block: 'start'
                    });
                }
            });
        });

        // Add animation on scroll
        const observerOptions = {
            threshold: 0.1,
            rootMargin: '0px 0px -50px 0px'
        };

        const observer = new IntersectionObserver((entries) => {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    entry.target.style.opacity = '1';
                    entry.target.style.transform = 'translateY(0)';
                }
            });
        }, observerOptions);

        // Observe feature cards
        document.querySelectorAll('.feature-card').forEach(card => {
            card.style.opacity = '0';
            card.style.transform = 'translateY(20px)';
            card.style.transition = 'opacity 0.6s ease, transform 0.6s ease';
            observer.observe(card);
        });
    </script>
</body>
</html>