<?php
include 'includes/db_connect.php';
include 'includes/functions.php';

if (!isLoggedIn()) {
    redirect('login.php');
}

$reason = $_GET['reason'] ?? 'unknown';
$reasons = [
    'payment_failed' => 'The payment was not successful. Please try again.',
    'verification_error' => 'We could not verify your payment. Please contact support.',
    'amount_mismatch' => 'The payment amount does not match the order total.',
    'transaction_not_found' => 'Transaction not found. Please contact support.',
    'unknown_error' => 'An unknown error occurred. Please try again.'
];

$error_message = $reasons[$reason] ?? $reasons['unknown_error'];
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payment Failed - MultiVendor System</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        .error-container {
            background: linear-gradient(135deg, #ff6b6b 0%, #ff9a44 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        .error-card {
            background: white;
            border-radius: 15px;
            padding: 40px;
            box-shadow: 0 15px 35px rgba(0,0,0,0.1);
            text-align: center;
            max-width: 500px;
            width: 100%;
        }
        .error-icon {
            font-size: 4rem;
            color: #ff6b6b;
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
    <div class="error-container">
        <div class="error-card">
            <div class="error-icon">
                <i class="fas fa-times-circle"></i>
            </div>
            <h2>Payment Failed</h2>
            <p class="text-muted"><?php echo $error_message; ?></p>
            
            <div class="d-grid gap-2">
                <a href="store_orders.php" class="btn btn-danger">
                    <i class="fas fa-redo me-2"></i>Try Again
                </a>
                <a href="store_dashboard.php" class="btn btn-outline-danger">
                    <i class="fas fa-tachometer-alt me-2"></i>Back to Dashboard
                </a>
            </div>
            
            <div class="mt-4">
                <small class="text-muted">
                    Need help? <a href="store_messages.php">Contact our support team</a>.
                </small>
            </div>
        </div>
    </div>
</body>
</html>