<?php
include 'includes/db_connect.php';
include 'includes/functions.php';

if (!isLoggedIn()) {
    redirect('login.php');
}

$order_id = $_GET['order_id'] ?? '';
$tx_ref = $_GET['tx_ref'] ?? '';

// Get order details
$order_stmt = $pdo->prepare("
    SELECT o.*, p.name as product_name, u.first_name, u.last_name 
    FROM orders o 
    JOIN products p ON o.product_id = p.id 
    JOIN users u ON o.company_id = u.id 
    WHERE o.id = ?
");
$order_stmt->execute([$order_id]);
$order = $order_stmt->fetch(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payment Successful - MultiVendor System</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        .success-container {
            background: linear-gradient(135deg, #42b883 0%, #47b8a4 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        .success-card {
            background: white;
            border-radius: 15px;
            padding: 40px;
            box-shadow: 0 15px 35px rgba(0,0,0,0.1);
            text-align: center;
            max-width: 500px;
            width: 100%;
        }
        .success-icon {
            font-size: 4rem;
            color: #42b883;
            margin-bottom: 20px;
        }
        .order-details {
            background: #f8f9fa;
            border-radius: 10px;
            padding: 20px;
            margin: 20px 0;
            text-align: left;
        }
    </style>
</head>
<body>
    <div class="success-container">
        <div class="success-card">
            <div class="success-icon">
                <i class="fas fa-check-circle"></i>
            </div>
            <h2>Payment Successful!</h2>
            <p class="text-muted">Thank you for your payment. Your order has been confirmed.</p>
            
            <?php if ($order): ?>
            <div class="order-details">
                <h5>Order Details</h5>
                <p><strong>Product:</strong> <?php echo $order['product_name']; ?></p>
                <p><strong>Quantity:</strong> <?php echo $order['quantity']; ?></p>
                <p><strong>Amount Paid:</strong> ₦<?php echo number_format($order['total_price'], 2); ?></p>
                <p><strong>Transaction Ref:</strong> <?php echo $tx_ref; ?></p>
                <p><strong>Company:</strong> <?php echo $order['first_name'] . ' ' . $order['last_name']; ?></p>
            </div>
            <?php endif; ?>
            
            <div class="d-grid gap-2">
                <a href="store_dashboard.php" class="btn btn-success">
                    <i class="fas fa-tachometer-alt me-2"></i>Back to Dashboard
                </a>
                <a href="store_order_history.php" class="btn btn-outline-success">
                    <i class="fas fa-history me-2"></i>View Order History
                </a>
            </div>
            
            <div class="mt-4">
                <small class="text-muted">
                    A confirmation email has been sent to your registered email address.
                </small>
            </div>
        </div>
    </div>
</body>
</html>