<?php
include 'includes/db_connect.php';
include 'includes/functions.php';

if (!isLoggedIn() || !isStore()) {
    redirect('login.php');
}

$user_id = $_SESSION['user_id'];

// Handle cart actions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['update_quantity'])) {
        $product_id = intval($_POST['product_id']);
        $quantity = intval($_POST['quantity']);
        
        if ($quantity > 0) {
            $_SESSION['cart'][$product_id]['quantity'] = $quantity;
        } else {
            unset($_SESSION['cart'][$product_id]);
        }
        
        $_SESSION['success'] = "Cart updated!";
    } elseif (isset($_POST['remove_item'])) {
        $product_id = intval($_POST['product_id']);
        unset($_SESSION['cart'][$product_id]);
        $_SESSION['success'] = "Item removed from cart!";
    } elseif (isset($_POST['place_order'])) {
        // Create orders for each cart item
        foreach ($_SESSION['cart'] as $item) {
            $total_price = $item['price'] * $item['quantity'];
            
            $order_stmt = $pdo->prepare("
                INSERT INTO orders (store_id, company_id, product_id, quantity, total_price, status, payment_status) 
                VALUES (?, ?, ?, ?, ?, 'Pending', 'Pending')
            ");
            $order_stmt->execute([
                $user_id, 
                $item['company_id'], 
                $item['product_id'], 
                $item['quantity'], 
                $total_price
            ]);
            
            $order_id = $pdo->lastInsertId();
            
            // Update product stock
            $update_stmt = $pdo->prepare("
                UPDATE products SET stock = stock - ? WHERE id = ?
            ");
            $update_stmt->execute([$item['quantity'], $item['product_id']]);
        }
        
        // Store order IDs for payment
        $_SESSION['pending_orders'] = $_SESSION['cart'];
        unset($_SESSION['cart']);
        
        redirect('process_flutterwave.php');
    }
}

$cart_total = 0;
if (isset($_SESSION['cart'])) {
    foreach ($_SESSION['cart'] as $item) {
        $cart_total += $item['price'] * $item['quantity'];
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Shopping Cart - MultiVendor System</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
</head>
<body>
    <?php include 'includes/store_sidebar.php'; ?>

    <div class="main-content" style="margin-left: 250px; padding: 20px;">
        <nav class="navbar navbar-expand-lg navbar-light bg-white shadow-sm mb-4">
            <div class="container-fluid">
                <span class="navbar-brand mb-0 h1">
                    <i class="fas fa-shopping-cart me-2"></i>Shopping Cart
                </span>
                <a href="store_orders.php" class="btn btn-outline-primary">
                    <i class="fas fa-arrow-left me-2"></i>Continue Shopping
                </a>
            </div>
        </nav>

        <?php if (isset($_SESSION['success'])): ?>
            <div class="alert alert-success alert-dismissible fade show">
                <?php echo $_SESSION['success']; unset($_SESSION['success']); ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        <div class="row">
            <div class="col-lg-8">
                <?php if (isset($_SESSION['cart']) && count($_SESSION['cart']) > 0): ?>
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Cart Items (<?php echo count($_SESSION['cart']); ?>)</h5>
                        </div>
                        <div class="card-body">
                            <?php foreach ($_SESSION['cart'] as $item): ?>
                                <div class="row align-items-center mb-4 pb-4 border-bottom">
                                    <div class="col-md-6">
                                        <h6><?php echo $item['name']; ?></h6>
                                        <p class="text-muted mb-0">₦<?php echo number_format($item['price'], 2); ?> per unit</p>
                                    </div>
                                    <div class="col-md-3">
                                        <form method="POST" class="d-flex align-items-center">
                                            <input type="hidden" name="product_id" value="<?php echo $item['product_id']; ?>">
                                            <input type="number" name="quantity" class="form-control" 
                                                   value="<?php echo $item['quantity']; ?>" min="1" 
                                                   max="<?php echo $item['stock']; ?>">
                                            <button type="submit" name="update_quantity" class="btn btn-sm btn-outline-primary ms-2">
                                                Update
                                            </button>
                                        </form>
                                    </div>
                                    <div class="col-md-2">
                                        <strong>₦<?php echo number_format($item['price'] * $item['quantity'], 2); ?></strong>
                                    </div>
                                    <div class="col-md-1">
                                        <form method="POST">
                                            <input type="hidden" name="product_id" value="<?php echo $item['product_id']; ?>">
                                            <button type="submit" name="remove_item" class="btn btn-sm btn-outline-danger">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                <?php else: ?>
                    <div class="card">
                        <div class="card-body text-center py-5">
                            <i class="fas fa-shopping-cart fa-3x text-muted mb-3"></i>
                            <h4 class="text-muted">Your cart is empty</h4>
                            <p class="text-muted">Add some products to your cart to continue.</p>
                            <a href="store_orders.php" class="btn btn-primary">Start Shopping</a>
                        </div>
                    </div>
                <?php endif; ?>
            </div>

            <div class="col-lg-4">
                <?php if (isset($_SESSION['cart']) && count($_SESSION['cart']) > 0): ?>
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Order Summary</h5>
                        </div>
                        <div class="card-body">
                            <div class="d-flex justify-content-between mb-3">
                                <span>Subtotal:</span>
                                <span>₦<?php echo number_format($cart_total, 2); ?></span>
                            </div>
                            <div class="d-flex justify-content-between mb-3">
                                <span>Shipping:</span>
                                <span>₦0.00</span>
                            </div>
                            <div class="d-flex justify-content-between mb-3">
                                <span>Tax:</span>
                                <span>₦0.00</span>
                            </div>
                            <hr>
                            <div class="d-flex justify-content-between mb-4">
                                <strong>Total:</strong>
                                <strong>₦<?php echo number_format($cart_total, 2); ?></strong>
                            </div>
                            
                            <form method="POST">
                                <button type="submit" name="place_order" class="btn btn-success w-100 btn-lg">
                                    <i class="fas fa-lock me-2"></i>Proceed to Payment
                                </button>
                            </form>
                            
                            <div class="mt-3 text-center">
                                <small class="text-muted">
                                    <i class="fas fa-lock me-1"></i>
                                    Your payment information is secure
                                </small>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>